<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T18:03:25.831517448 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Cortex-A720" />
    <supported-cpuid id="Cortex-A720AE" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions per Cycle (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleCortexA720CPU_CYCLES &gt; 0), ($InstructionsPerCycleCortexA720INST_RETIRED / $InstructionsPerCycleCortexA720CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Cycle Accounting (Cortex-A720)">
        <series color="255,153,0" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesCortexA720CPU_CYCLES &gt; 0), min(($FrontendStalledCyclesCortexA720STALL_FRONTEND / $FrontendStalledCyclesCortexA720CPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesCortexA720CPU_CYCLES &gt; 0), min(($BackendStalledCyclesCortexA720STALL_BACKEND / $BackendStalledCyclesCortexA720CPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Level 1 (Cortex-A720)">
        <series color="255,153,0" description="This metric is the percentage of total slots that were stalled due to resource constraints in the frontend of the processor" expression="if(($FrontendBoundCortexA720CPU_CYCLES &gt; 0), min((($FrontendBoundCortexA720STALL_SLOT_FRONTEND / (5 * $FrontendBoundCortexA720CPU_CYCLES)) - ($FrontendBoundCortexA720STALL_FRONTEND_FLUSH / $FrontendBoundCortexA720CPU_CYCLES)), 1), 0)" name="Frontend Bound" units="percent"/>
        <series color="255,0,229" description="This metric is the percentage of total slots that were stalled due to resource constraints in the backend of the processor" expression="if(($BackendBoundCortexA720CPU_CYCLES &gt; 0), min(($BackendBoundCortexA720STALL_SLOT_BACKEND / (5 * $BackendBoundCortexA720CPU_CYCLES)), 1), 0)" name="Backend Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total slots that retired operations, which indicates cycles that were utilized efficiently" expression="if(($RetiringCortexA720CPU_CYCLES &gt; 0) &amp;&amp; ($RetiringCortexA720OP_SPEC &gt; 0), min(((1 - ($RetiringCortexA720STALL_SLOT / ($RetiringCortexA720CPU_CYCLES * 5))) * ($RetiringCortexA720OP_RETIRED / $RetiringCortexA720OP_SPEC)), 1), 0)" name="Retiring" units="percent"/>
        <series color="0,255,25" description="This metric is the percentage of total slots that executed operations and didn't retire due to a pipeline flush This indicates cycles that were utilized but inefficiently" expression="if(($BadSpeculationCortexA720CPU_CYCLES &gt; 0) &amp;&amp; ($BadSpeculationCortexA720OP_SPEC &gt; 0), min((((1 - ($BadSpeculationCortexA720STALL_SLOT / (5 * $BadSpeculationCortexA720CPU_CYCLES))) * (1 - ($BadSpeculationCortexA720OP_RETIRED / $BadSpeculationCortexA720OP_SPEC))) + ($BadSpeculationCortexA720STALL_FRONTEND_FLUSH / $BadSpeculationCortexA720CPU_CYCLES)), 1), 0)" name="Bad Speculation" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="General (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the percentage of operations speculatively executed that are subsequently retired" expression="if(($RetiredOperationsPercentageCortexA720OP_SPEC &gt; 0), min(($RetiredOperationsPercentageCortexA720OP_RETIRED / $RetiredOperationsPercentageCortexA720OP_SPEC), 1), 0)" name="Retired Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints not related to instruction fetch latency issues caused by memory access components" expression="if(($FrontendCoreBoundCortexA720STALL_FRONTEND &gt; 0), min(($FrontendCoreBoundCortexA720STALL_FRONTEND_CPUBOUND / $FrontendCoreBoundCortexA720STALL_FRONTEND), 1), 0)" name="Frontend Core Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints related to the instruction fetch latency issues caused by memory access components" expression="if(($FrontendMemoryBoundCortexA720STALL_FRONTEND &gt; 0), min(($FrontendMemoryBoundCortexA720STALL_FRONTEND_MEMBOUND / $FrontendMemoryBoundCortexA720STALL_FRONTEND), 1), 0)" name="Frontend Memory Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Core Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend as the processor is recovering from a pipeline flush caused by bad speculation or other machine resteers" expression="if(($FrontendCoreFlushBoundCortexA720STALL_FRONTEND_CPUBOUND &gt; 0), min(($FrontendCoreFlushBoundCortexA720STALL_FRONTEND_FLUSH / $FrontendCoreFlushBoundCortexA720STALL_FRONTEND_CPUBOUND), 1), 0)" name="Frontend Core Flush Bound" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction Cache Effectiveness (Frontend Cache L1I Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKICortexA720INST_RETIRED &gt; 0), (($L1ICacheMPKICortexA720L1I_CACHE_REFILL / $L1ICacheMPKICortexA720INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction Cache Effectiveness (Frontend Cache L1I Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageCortexA720L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageCortexA720L1I_CACHE_REFILL / $L1ICacheMissPercentageCortexA720L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Memory Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency issues caused by instruction TLB misses" expression="if(($FrontendMemTLBBoundCortexA720STALL_FRONTEND_MEMBOUND &gt; 0), min(($FrontendMemTLBBoundCortexA720STALL_FRONTEND_TLB / $FrontendMemTLBBoundCortexA720STALL_FRONTEND_MEMBOUND), 1), 0)" name="Frontend Mem TLB Bound" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKICortexA720INST_RETIRED &gt; 0), (($ITLBMPKICortexA720ITLB_WALK / $ITLBMPKICortexA720INST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
        <series color="0,102,255" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKICortexA720INST_RETIRED &gt; 0), (($L1InstructionTLBMPKICortexA720L1I_TLB_REFILL / $L1InstructionTLBMPKICortexA720INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageCortexA720L1I_TLB &gt; 0), min(($ITLBWalkPercentageCortexA720ITLB_WALK / $ITLBWalkPercentageCortexA720L1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
        <series color="255,0,229" description="This metric measures the ratio of instruction TLB Walks that returned large page to the total number of instruction TLB accesses" expression="if(($ITLBWalkLargePagePercentageCortexA720L1I_TLB &gt; 0), min(($ITLBWalkLargePagePercentageCortexA720ITLB_WALK_LARGE / $ITLBWalkLargePagePercentageCortexA720L1I_TLB), 1), 0)" name="ITLB Walk Large Page Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of instruction TLB Walks that returned large page to the total number of instruction TLB accesses" expression="if(($ITLBWalkSmallPagePercentageCortexA720L1I_TLB &gt; 0), min(($ITLBWalkSmallPagePercentageCortexA720ITLB_WALK_SMALL / $ITLBWalkSmallPagePercentageCortexA720L1I_TLB), 1), 0)" name="ITLB Walk Small Page Percentage" units="percent"/>
        <series color="0,255,25" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageCortexA720L1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageCortexA720L1I_TLB_REFILL / $L1InstructionTLBMissPercentageCortexA720L1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the average depth of the instruction TLB walks for an instruction TLB refill" expression="if(($ITLBWalkAverageDepthOfAccessesCortexA720ITLB_WALK &gt; 0), ($ITLBWalkAverageDepthOfAccessesCortexA720ITLB_STEP / $ITLBWalkAverageDepthOfAccessesCortexA720ITLB_WALK), 0)" name="ITLB Walk Average Depth of Accesses" units="accesses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the average latency of instruction TLB walks in CPU cycles" expression="if(($ITLBWalkAverageLatencyCortexA720ITLB_WALK &gt; 0), ($ITLBWalkAverageLatencyCortexA720ITLB_WALK_PERCYC / $ITLBWalkAverageLatencyCortexA720ITLB_WALK), 0)" name="ITLB Walk Average Latency" units="cycles"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to backend core resource constraints not related to instruction fetch latency issues caused by memory access components" expression="if(($BackendCoreBoundCortexA720STALL_BACKEND &gt; 0), min(($BackendCoreBoundCortexA720STALL_BACKEND_CPUBOUND / $BackendCoreBoundCortexA720STALL_BACKEND), 1), 0)" name="Backend Core Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the backend due to backend core resource constraints related to memory access latency issues caused by memory access components" expression="if(($BackendMemoryBoundCortexA720STALL_BACKEND &gt; 0), min(($BackendMemoryBoundCortexA720STALL_BACKEND_MEMBOUND / $BackendMemoryBoundCortexA720STALL_BACKEND), 1), 0)" name="Backend Memory Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Core Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend as the rename unit registers are unavailable" expression="if(($BackendCoreRenameBoundCortexA720STALL_BACKEND_CPUBOUND &gt; 0), min(($BackendCoreRenameBoundCortexA720STALL_BACKEND_RENAME / $BackendCoreRenameBoundCortexA720STALL_BACKEND_CPUBOUND), 1), 0)" name="Backend Core Rename Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Core Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to issue queues being full to accept operations for execution" expression="if(($BackendBusyBoundCortexA720STALL_BACKEND &gt; 0), min(($BackendBusyBoundCortexA720STALL_BACKEND_BUSY / $BackendBusyBoundCortexA720STALL_BACKEND), 1), 0)" name="Backend Busy Bound" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data Cache Effectiveness (Backend Cache L1D Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKICortexA720INST_RETIRED &gt; 0), (($L1DCacheMPKICortexA720L1D_CACHE_REFILL / $L1DCacheMPKICortexA720INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data Cache Effectiveness (Backend Cache L1D Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageCortexA720L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageCortexA720L1D_CACHE_REFILL / $L1DCacheMissPercentageCortexA720L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified Cache Effectiveness (Backend Cache L2D Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKICortexA720INST_RETIRED &gt; 0), (($L2CacheMPKICortexA720L2D_CACHE_REFILL / $L2CacheMPKICortexA720INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Unified Cache Effectiveness (Backend Cache L2D Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageCortexA720L2D_CACHE &gt; 0), min(($L2CacheMissPercentageCortexA720L2D_CACHE_REFILL / $L2CacheMissPercentageCortexA720L2D_CACHE), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Unified Cache Effectiveness (Backend Cache L2D Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKICortexA720INST_RETIRED &gt; 0), (($L3CacheMPKICortexA720L3D_CACHE_REFILL / $L3CacheMPKICortexA720INST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Unified Cache Effectiveness (Backend Cache L2D Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageCortexA720L3D_CACHE &gt; 0), min(($L3CacheMissPercentageCortexA720L3D_CACHE_REFILL / $L3CacheMissPercentageCortexA720L3D_CACHE), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Last Level Cache Effectiveness (Backend Cache L2D Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKICortexA720INST_RETIRED &gt; 0), (($LLCacheReadMPKICortexA720LL_CACHE_MISS_RD / $LLCacheReadMPKICortexA720INST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Last Level Cache Effectiveness (Backend Cache L2D Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageCortexA720LL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageCortexA720LL_CACHE_MISS_RD / $LLCacheReadMissPercentageCortexA720LL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageCortexA720LL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageCortexA720LL_CACHE_RD - $LLCacheReadHitPercentageCortexA720LL_CACHE_MISS_RD) / $LLCacheReadHitPercentageCortexA720LL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Memory Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by data TLB misses" expression="if(($BackendMemoryTLBBoundCortexA720STALL_BACKEND_MEMBOUND &gt; 0), min(($BackendMemoryTLBBoundCortexA720STALL_BACKEND_TLB / $BackendMemoryTLBBoundCortexA720STALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory TLB Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend due to memory write pending caused by stores stalled in the pre-commit stage" expression="if(($BackendMemoryStoreBoundCortexA720STALL_BACKEND_MEMBOUND &gt; 0), min(($BackendMemoryStoreBoundCortexA720STALL_BACKEND_ST / $BackendMemoryStoreBoundCortexA720STALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory Store Bound" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKICortexA720INST_RETIRED &gt; 0), (($DTLBMPKICortexA720DTLB_WALK / $DTLBMPKICortexA720INST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
        <series color="153,0,255" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKICortexA720INST_RETIRED &gt; 0), (($L1DataTLBMPKICortexA720L1D_TLB_REFILL / $L1DataTLBMPKICortexA720INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
        <series color="0,255,153" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKICortexA720INST_RETIRED &gt; 0), (($L2UnifiedTLBMPKICortexA720L2D_TLB_REFILL / $L2UnifiedTLBMPKICortexA720INST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageCortexA720L1D_TLB &gt; 0), min(($DTLBWalkPercentageCortexA720DTLB_WALK / $DTLBWalkPercentageCortexA720L1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
        <series color="255,0,153" description="This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB accesses" expression="if(($DTLBWalkLargePagePercentageCortexA720L1D_TLB &gt; 0), min(($DTLBWalkLargePagePercentageCortexA720DTLB_WALK_LARGE / $DTLBWalkLargePagePercentageCortexA720L1D_TLB), 1), 0)" name="DTLB Walk Large Page Percentage" units="percent"/>
        <series color="51,0,255" description="This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB accesses" expression="if(($DTLBWalkSmallPagePercentageCortexA720L1D_TLB &gt; 0), min(($DTLBWalkSmallPagePercentageCortexA720DTLB_WALK_SMALL / $DTLBWalkSmallPagePercentageCortexA720L1D_TLB), 1), 0)" name="DTLB Walk Small Page Percentage" units="percent"/>
        <series color="0,255,255" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageCortexA720L1D_TLB &gt; 0), min(($L1DataTLBMissPercentageCortexA720L1D_TLB_REFILL / $L1DataTLBMissPercentageCortexA720L1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
        <series color="51,255,0" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageCortexA720L2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageCortexA720L2D_TLB_REFILL / $L2UnifiedTLBMissPercentageCortexA720L2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the average depth of the data TLB walks for a data TLB refill" expression="if(($DTLBWalkAverageDepthOfAccessesCortexA720DTLB_WALK &gt; 0), ($DTLBWalkAverageDepthOfAccessesCortexA720DTLB_STEP / $DTLBWalkAverageDepthOfAccessesCortexA720DTLB_WALK), 0)" name="DTLB Walk Average Depth of Accesses" units="accesses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the average latency of data TLB walks in CPU cycles" expression="if(($DTLBWalkAverageLatencyCortexA720DTLB_WALK &gt; 0), ($DTLBWalkAverageLatencyCortexA720DTLB_WALK_PERCYC / $DTLBWalkAverageLatencyCortexA720DTLB_WALK), 0)" name="DTLB Walk Average Latency" units="cycles"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Atomics Effectiveness (Backend Memory Bound) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the ratio of failed compare and swap instructions speculatively executed locally to the PE that do not update the location accessed to the total near compare and swap instructions" expression="if(($CompareAndSwapNearFailPercentageCortexA720CAS_NEAR_SPEC &gt; 0), min((1 - ($CompareAndSwapNearFailPercentageCortexA720CAS_NEAR_PASS / $CompareAndSwapNearFailPercentageCortexA720CAS_NEAR_SPEC)), 1), 0)" name="Compare and Swap Near Fail Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of passed compare and swap instructions speculatively executed locally to the PE that updated the location accessed to the total near compare and swap instructions" expression="if(($CompareAndSwapNearPassPercentageCortexA720CAS_NEAR_SPEC &gt; 0), min(($CompareAndSwapNearPassPercentageCortexA720CAS_NEAR_PASS / $CompareAndSwapNearPassPercentageCortexA720CAS_NEAR_SPEC), 1), 0)" name="Compare and Swap Near Pass Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures instruction and data barrier operations as a percentage of operations speculatively executed" expression="if(($BarrierOperationsPercentageCortexA720INST_SPEC &gt; 0), min(((($BarrierOperationsPercentageCortexA720ISB_SPEC + $BarrierOperationsPercentageCortexA720DSB_SPEC) + $BarrierOperationsPercentageCortexA720DMB_SPEC) / $BarrierOperationsPercentageCortexA720INST_SPEC), 1), 0)" name="Barrier Operations Percentage" units="percent"/>
        <series color="255,0,102" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageCortexA720INST_SPEC &gt; 0), min(($CryptoOperationsPercentageCortexA720CRYPTO_SPEC / $CryptoOperationsPercentageCortexA720INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageCortexA720INST_SPEC &gt; 0), min((($IntegerOperationsPercentageCortexA720DP_SPEC - $IntegerOperationsPercentageCortexA720DSB_SPEC) / $IntegerOperationsPercentageCortexA720INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageCortexA720INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageCortexA720VFP_SPEC / $FloatingPointOperationsPercentageCortexA720INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageCortexA720INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageCortexA720ASE_SPEC / $AdvancedSIMDOperationsPercentageCortexA720INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
        <series color="102,255,0" description="This metric measures scalable vector operations, including loads and stores, as a percentage of operations speculatively executed" expression="if(($SVEOperationsLoadStoreInclusivePercentageCortexA720INST_SPEC &gt; 0), min(($SVEOperationsLoadStoreInclusivePercentageCortexA720SVE_INST_SPEC / $SVEOperationsLoadStoreInclusivePercentageCortexA720INST_SPEC), 1), 0)" name="SVE Operations (Load/Store Inclusive) Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures half-precision floating point operations as a percentage of operations speculatively executed" expression="if(($HalfPrecisionFloatingPointPercentageCortexA720INST_SPEC &gt; 0), min(($HalfPrecisionFloatingPointPercentageCortexA720FP_HP_SPEC / $HalfPrecisionFloatingPointPercentageCortexA720INST_SPEC), 1), 0)" name="Half Precision Floating Point Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures single-precision floating point operations as a percentage of operations speculatively executed" expression="if(($SinglePrecisionFloatingPointPercentageCortexA720INST_SPEC &gt; 0), min(($SinglePrecisionFloatingPointPercentageCortexA720FP_SP_SPEC / $SinglePrecisionFloatingPointPercentageCortexA720INST_SPEC), 1), 0)" name="Single Precision Floating Point Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures double-precision floating point operations as a percentage of operations speculatively executed" expression="if(($DoublePrecisionFloatingPointPercentageCortexA720INST_SPEC &gt; 0), min(($DoublePrecisionFloatingPointPercentageCortexA720FP_DP_SPEC / $DoublePrecisionFloatingPointPercentageCortexA720INST_SPEC), 1), 0)" name="Double Precision Floating Point Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageCortexA720INST_SPEC &gt; 0), min(($LoadOperationsPercentageCortexA720LD_SPEC / $LoadOperationsPercentageCortexA720INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageCortexA720INST_SPEC &gt; 0), min(($StoreOperationsPercentageCortexA720ST_SPEC / $StoreOperationsPercentageCortexA720INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of instructions speculatively executed" expression="if(($LoadAcquireInstructionsPercentageCortexA720INST_SPEC &gt; 0), min(($LoadAcquireInstructionsPercentageCortexA720RC_LD_SPEC / $LoadAcquireInstructionsPercentageCortexA720INST_SPEC), 1), 0)" name="Load-Acquire Instructions Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures memory-write instructions with release semantics as a percentage of instructions speculatively executed" expression="if(($StoreReleaseInstructionsPercentageCortexA720INST_SPEC &gt; 0), min(($StoreReleaseInstructionsPercentageCortexA720RC_ST_SPEC / $StoreReleaseInstructionsPercentageCortexA720INST_SPEC), 1), 0)" name="Store-Release Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures store-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($StoreExclusiveInstructionsPercentageCortexA720INST_SPEC &gt; 0), min(($StoreExclusiveInstructionsPercentageCortexA720STREX_SPEC / $StoreExclusiveInstructionsPercentageCortexA720INST_SPEC), 1), 0)" name="Store-Exclusive Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch Effectiveness (Bad Speculation) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKICortexA720INST_RETIRED &gt; 0), (($BranchMPKICortexA720BR_MIS_PRED_RETIRED / $BranchMPKICortexA720INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Effectiveness (Bad Speculation) (Cortex-A720)">
        <series color="255,153,0" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageCortexA720BR_RETIRED &gt; 0), min(($BranchMispredictionPercentageCortexA720BR_MIS_PRED_RETIRED / $BranchMispredictionPercentageCortexA720BR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
        <series color="255,0,229" description="This metric measures the ratio of direct branches retired to the total number of branches architecturally executed" expression="if(($BranchDirectPercentageCortexA720BR_RETIRED &gt; 0), min(($BranchDirectPercentageCortexA720BR_IMMED_RETIRED / $BranchDirectPercentageCortexA720BR_RETIRED), 1), 0)" name="Branch Direct Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of indirect branches retired, including function returns, to the total number of branches architecturally executed" expression="if(($BranchIndirectPercentageCortexA720BR_RETIRED &gt; 0), min(($BranchIndirectPercentageCortexA720BR_IND_RETIRED / $BranchIndirectPercentageCortexA720BR_RETIRED), 1), 0)" name="Branch Indirect Percentage" units="percent"/>
        <series color="0,255,25" description="This metric measures the ratio of branches retired that are function returns to the total number of branches architecturally executed" expression="if(($BranchReturnPercentageCortexA720BR_RETIRED &gt; 0), min(($BranchReturnPercentageCortexA720BR_RETURN_RETIRED / $BranchReturnPercentageCortexA720BR_RETIRED), 1), 0)" name="Branch Return Percentage" units="percent"/>
   </chart>
    <select-metric id="ARMv9_Cortex_A720AE_metric_backend_bound" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_backend_busy_bound" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_backend_core_bound" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_backend_core_rename_bound" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_backend_mem_bound" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_backend_mem_store_bound" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_backend_mem_tlb_bound" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_backend_stalled_cycles" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_bad_speculation" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_barrier_percentage" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_branch_direct_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_branch_indirect_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_branch_mpki" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_branch_return_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_cas_near_fail_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_cas_near_pass_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_crypto_percentage" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_dtlb_mpki" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_dtlb_walk_average_depth" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_dtlb_walk_average_latency" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_dtlb_walk_large_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_dtlb_walk_small_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_fp16_percentage" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_fp32_percentage" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_fp64_percentage" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_frontend_bound" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_frontend_core_bound" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_frontend_core_flush_bound" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_frontend_mem_bound" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_frontend_mem_tlb_bound" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_integer_dp_percentage" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_ipc" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_itlb_mpki" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_itlb_walk_average_depth" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_itlb_walk_average_latency" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_itlb_walk_large_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_itlb_walk_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_itlb_walk_small_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_l1d_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_l1i_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_l2_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_l2_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_l3_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_load_percentage" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_rc_ld_percentage" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_rc_st_percentage" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_retired_ops_percent" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_retiring" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_scalar_fp_percentage" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_simd_percentage" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_store_percentage" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_strex_percentage" />
    <select-metric id="ARMv9_Cortex_A720AE_metric_sve_all_percentage" />
    <select-metric id="ARMv9_Cortex_A720_metric_backend_bound" />
    <select-metric id="ARMv9_Cortex_A720_metric_backend_busy_bound" />
    <select-metric id="ARMv9_Cortex_A720_metric_backend_core_bound" />
    <select-metric id="ARMv9_Cortex_A720_metric_backend_core_rename_bound" />
    <select-metric id="ARMv9_Cortex_A720_metric_backend_mem_bound" />
    <select-metric id="ARMv9_Cortex_A720_metric_backend_mem_store_bound" />
    <select-metric id="ARMv9_Cortex_A720_metric_backend_mem_tlb_bound" />
    <select-metric id="ARMv9_Cortex_A720_metric_backend_stalled_cycles" />
    <select-metric id="ARMv9_Cortex_A720_metric_bad_speculation" />
    <select-metric id="ARMv9_Cortex_A720_metric_barrier_percentage" />
    <select-metric id="ARMv9_Cortex_A720_metric_branch_direct_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_branch_indirect_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_branch_mpki" />
    <select-metric id="ARMv9_Cortex_A720_metric_branch_return_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_cas_near_fail_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_cas_near_pass_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_crypto_percentage" />
    <select-metric id="ARMv9_Cortex_A720_metric_dtlb_mpki" />
    <select-metric id="ARMv9_Cortex_A720_metric_dtlb_walk_average_depth" />
    <select-metric id="ARMv9_Cortex_A720_metric_dtlb_walk_average_latency" />
    <select-metric id="ARMv9_Cortex_A720_metric_dtlb_walk_large_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_dtlb_walk_small_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_fp16_percentage" />
    <select-metric id="ARMv9_Cortex_A720_metric_fp32_percentage" />
    <select-metric id="ARMv9_Cortex_A720_metric_fp64_percentage" />
    <select-metric id="ARMv9_Cortex_A720_metric_frontend_bound" />
    <select-metric id="ARMv9_Cortex_A720_metric_frontend_core_bound" />
    <select-metric id="ARMv9_Cortex_A720_metric_frontend_core_flush_bound" />
    <select-metric id="ARMv9_Cortex_A720_metric_frontend_mem_bound" />
    <select-metric id="ARMv9_Cortex_A720_metric_frontend_mem_tlb_bound" />
    <select-metric id="ARMv9_Cortex_A720_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv9_Cortex_A720_metric_integer_dp_percentage" />
    <select-metric id="ARMv9_Cortex_A720_metric_ipc" />
    <select-metric id="ARMv9_Cortex_A720_metric_itlb_mpki" />
    <select-metric id="ARMv9_Cortex_A720_metric_itlb_walk_average_depth" />
    <select-metric id="ARMv9_Cortex_A720_metric_itlb_walk_average_latency" />
    <select-metric id="ARMv9_Cortex_A720_metric_itlb_walk_large_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_itlb_walk_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_itlb_walk_small_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_l1d_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A720_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_A720_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_l1i_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A720_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_A720_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_l2_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A720_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_l2_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_A720_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_l3_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A720_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A720_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv9_Cortex_A720_metric_load_percentage" />
    <select-metric id="ARMv9_Cortex_A720_metric_rc_ld_percentage" />
    <select-metric id="ARMv9_Cortex_A720_metric_rc_st_percentage" />
    <select-metric id="ARMv9_Cortex_A720_metric_retired_ops_percent" />
    <select-metric id="ARMv9_Cortex_A720_metric_retiring" />
    <select-metric id="ARMv9_Cortex_A720_metric_scalar_fp_percentage" />
    <select-metric id="ARMv9_Cortex_A720_metric_simd_percentage" />
    <select-metric id="ARMv9_Cortex_A720_metric_store_percentage" />
    <select-metric id="ARMv9_Cortex_A720_metric_strex_percentage" />
    <select-metric id="ARMv9_Cortex_A720_metric_sve_all_percentage" />
</template>
